import pandas as pd   
import pickle
from decision_company import read_csv_file, df_copy, cast_to_a_dtype, categoricalIndex, categorical_codes

# Load the dataset  
credit_customers = read_csv_file("credit_customers.csv")
  
# Create a new DataFrame with numerical values for credit_history and employment  
credit_customers_numerical = df_copy(credit_customers)  
credit_customers_numerical['credit_history'] = categorical_codes(categoricalIndex(cast_to_a_dtype(credit_customers_numerical['credit_history'], 'category')))
credit_customers_numerical['employment'] = categorical_codes(categoricalIndex(cast_to_a_dtype(credit_customers_numerical['employment'], 'category')))  
  
print(credit_customers_numerical)
pickle.dump(credit_customers_numerical,open("./ref_result/credit_customers_numerical.pkl","wb"))

  